'##############################################################
'SpannungMessen1.bas
'
'Ein kleines Testprogramm fr RN-AVR UNIVERSAL bzw. ATMega644
'
'Das programm demonstriert wie man die Spannung an einem
'analogem Port messen kann. Es wird auch genau gezeigt wie
'man Spannungsteiler und Spannung berechnet.
'Die verwendeten Widerstandswerte fr den Spannungsteiler
'knnen einfach den Variablen R1 und R2 zugewiesen werden
'Das Programm demonstriert auch, das auch sehr hochhohmige
'Widerstnde am Spannungsteiler durchaus gute Ergebnisse liefern
'wenn keine blitzschnellen Messungen (mehrere pro Sekunde ntig sind).
'Das Programm zeigt auch den bentigten Strom pro Spannungsteiler an.
' (c) Frank Brall 2013
'Software und RN-AVR UNIVERSAL Bezug ber www.robotikhardware.de DVD
'Weitere Beispiele auf DVD von robotikhardware.de
'oder im www.Roboternetz.de und rn-wissen.de

'######################################################################

'Portbelegung:
'Spannungsteiler aus R1 und R2 an PA0
'Werteausgabe ber RS232/USB



$programmer = 12                    'MCS USB  (Zeile weglassen wenn anderer Programmer)
$prog &HFF , &HFF , &HD9 , &HFE      'Fusebits richtig programmieren (Quarz ein,Jtag aus)

$regfile = "m644pdef.dat" ' oder $regfile = "m644def.dat"
$framesize = 64
$swstack = 64
$hwstack = 64

$crystal = 8000000                                          'Quarzfrequenz


Config Pind.6 = Output                                      'LED
Led1 Alias Portd.6


Config Pina.0 = Input
BattAdc Alias Pina.0
Config Adc = Single , Prescaler = 128 , Reference = INTERNAL_1.1


dim adcbattwert as integer
dim r1 as  single
dim r2 as  single
dim rg as  single
dim uref as single
dim udigit as single
dim vh as single
dim spannung as single
dim strom as single

Start Adc
Do
    Toggle Led1


    r1=900 'Spannungsteiler Widerstand 1 in kOhm
    r2=100 'Spannungsteiler Widerstand 2 in kOhm
    uref=1100 'Referenzspannung im mV 1,1V =1100mV
    vh=r1/r2 'Verhltnis ausrechnen
    udigit=uref/1024
    adcbattwert=Getadc(0)
    spannung= adcbattwert*udigit
    spannung=spannung*vh
    spannung=spannung/1000 'In Volt umrechnen
    rg=r1+r2
    strom= spannung/ rg
    print "ADC-Wert:"; adcbattwert
    print "Spannung V:"; Fusing(spannung , "#.##") ; "  Strombedarf Spannungsteiler in mA: "; Fusing(strom , "#.###")

    Wait 1
Loop




